package com.ejie.ab04b.service.platea;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.ConstantesPlateaTramitacion;
import com.ejie.ab04b.constantes.TipoTareaPlatea;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.util.PlateaTramitacionUtils;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.webservice.client.cdt.Q99OFolderFacadeWSSoap;
import com.ejie.mbt.xml.Task;

/**
 * @author GFI-NORTE
 * 
 */
@Service(value = "plateaTramitacionService")
public class PlateaTramitacionService {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(PlateaTramitacionService.class);

	@Autowired()
	private Q99OFolderFacadeWSSoap q99OFolderFacadeWSSoap;

	/**
	 * sProcedureID String sProceedingID String sTaskID String sIDExp String
	 * sSenderId String sSenderName String.
	 *
	 * @param sProcedureID
	 *            the s procedure ID
	 * @param sProceedingID
	 *            the s proceeding ID
	 * @param sTaskID
	 *            the s task ID
	 * @param sIDExp
	 *            the s ID exp
	 * @param sSenderId
	 *            the s sender id
	 * @param sSenderName
	 *            the s sender name
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public void crearTarea(String sProcedureID, String sProceedingID,
			String sTaskID, String sIDExp, String sSenderId, String sSenderName)
			throws AB04BException {
		try {

			Object[] params = new Object[] { sProcedureID, sProceedingID,
					sTaskID, sIDExp, sSenderId, sSenderName };
			PlateaTramitacionService.LOGGER.info(
					"Entra en crearTarea: sProcedureID {}, sProceedingID {}, sTaskID {}, sIDExp {}, sSenderId {}, sSenderName {}",
					params);

			String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

			this.q99OFolderFacadeWSSoap.prepareNewTask(sSessionToken,
					sProcedureID, sProceedingID, sTaskID, sIDExp, sSenderId,
					sSenderName);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * sGUID String tipoTarea TipoTareaPlatea Task.
	 *
	 * @param sGUID
	 *            the s GUID
	 * @param tipoTarea
	 *            the tipo tarea
	 * @return the task
	 */
	public Task prepararTarea(String sGUID, TipoTareaPlatea tipoTarea) {

		PlateaTramitacionService.LOGGER.info(
				"Entra en prepararTarea: id {}, tipoTarea {}", sGUID,
				tipoTarea.name());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		try {
			String response = this.q99OFolderFacadeWSSoap
					.prepareTask(sSessionToken, sGUID, tipoTarea.name());

			return PlateaTramitacionUtils.getInstance()
					.getPlateaResponseAsTask(response);
		} catch (Exception e) {
			PlateaTramitacionService.LOGGER.info(
					"Entra en la llamada q99OFolderFacadeWSSoap.prepareTask",
					e);

			return null;
		}
	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task aperturaExpediente(Task task) {

		PlateaTramitacionService.LOGGER.info(
				"Entra en aperturaExpediente: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		try {
			String sTask = PlateaTramitacionUtils.getInstance()
					.unparseTaskToString(task);
			String response = this.q99OFolderFacadeWSSoap
					.doTaskOpen(sSessionToken, sTask);

			return PlateaTramitacionUtils.getInstance()
					.getPlateaResponseAsTask(response);
		} catch (Exception e) {
			PlateaTramitacionService.LOGGER.info(
					"Entra en la llamada q99OFolderFacadeWSSoap.doTaskOpen", e);

			return null;
		}
	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task estudiarDocumentacion(Task task) {
		PlateaTramitacionService.LOGGER.info(
				"Entra en estudiarDocumentacion: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		try {
			String sTask = PlateaTramitacionUtils.getInstance()
					.unparseTaskToString(task);
			String response = this.q99OFolderFacadeWSSoap
					.doTaskStudy(sSessionToken, sTask);

			return PlateaTramitacionUtils.getInstance()
					.getPlateaResponseAsTask(response);
		} catch (Exception e) {
			PlateaTramitacionService.LOGGER.info(
					"Entra en la llamada estudiarDocumentacion.doTaskStudy", e);

			return null;
		}
	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task aportarDocumentacion(Task task) {

		PlateaTramitacionService.LOGGER.info(
				"Entra en aportarDocumentacion: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		try {
			String sTask = PlateaTramitacionUtils.getInstance()
					.unparseTaskToString(task);
			String response = this.q99OFolderFacadeWSSoap
					.doTaskAdjuntarDoc(sSessionToken, sTask);

			return PlateaTramitacionUtils.getInstance()
					.getPlateaResponseAsTask(response);
		} catch (Exception e) {
			PlateaTramitacionService.LOGGER.error(
					"Error en la llamada q99OFolderFacadeWSSoap.doTaskAdjuntarDoc",
					e);

			return null;
		}
	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task registrarDocumentacion(Task task) {

		PlateaTramitacionService.LOGGER.info(
				"Entra en registrarDocumentacion: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		try {
			String sTask = PlateaTramitacionUtils.getInstance()
					.unparseTaskToString(task);
			String response = this.q99OFolderFacadeWSSoap
					.doTaskRegistrarDoc(sSessionToken, sTask);

			return PlateaTramitacionUtils.getInstance()
					.getPlateaResponseAsTask(response);
		} catch (Exception e) {
			PlateaTramitacionService.LOGGER.error(
					"Error en la llamada q99OFolderFacadeWSSoap.doTaskRegistrarDoc",
					e);

			return null;
		}
	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task enviarComunicacion(Task task) {

		PlateaTramitacionService.LOGGER.info(
				"Entra en enviarComunicacion: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		String sTask = PlateaTramitacionUtils.getInstance()
				.unparseTaskToString(task);

		// Genera el ejgvdocument
		String response = this.q99OFolderFacadeWSSoap
				.createTeleNotificationX(sSessionToken, sTask);

		if (ConstantesPlateaTramitacion.CS_TIPO_NOTIF_ELECTRONICA.equals(task
				.getTaskInfo().getNotifyTaskData().getNotificationFormat())) {
			// Crea la notificación con firma de servidor
			response = this.q99OFolderFacadeWSSoap
					.doTaskCrearNotServer(sSessionToken, response);
		} else if (ConstantesPlateaTramitacion.CS_TIPO_NOTIF_POSTAL.equals(task
				.getTaskInfo().getNotifyTaskData().getNotificationFormat())) {
			// Registra la notificación postal
			response = this.q99OFolderFacadeWSSoap.doTaskG(sSessionToken,
					response);
		}

		return PlateaTramitacionUtils.getInstance()
				.getPlateaResponseAsTask(response);

	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task registraComunicacionPostal(Task task) throws Exception {

		PlateaTramitacionService.LOGGER.info(
				"Entra en registraComunicacionPostal: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		String sTask = PlateaTramitacionUtils.getInstance()
				.unparseTaskToString(task);
		String response = this.q99OFolderFacadeWSSoap
				.doTaskRegistrarNotifPostal(sSessionToken, sTask);

		return PlateaTramitacionUtils.getInstance()
				.getPlateaResponseAsTask(response);

	}

	/**
	 * task Task Task.
	 *
	 * @param task
	 *            the task
	 * @return the task
	 */
	public Task acuseRequerimiento(Task task) {

		PlateaTramitacionService.LOGGER.info(
				"Entra en registrarDocumentacion: getMailboxTaskID {}",
				task.getMailboxTaskID());

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		try {
			String sTask = PlateaTramitacionUtils.getInstance()
					.unparseTaskToString(task);
			String response = this.q99OFolderFacadeWSSoap
					.doTaskAcuse(sSessionToken, sTask);

			return PlateaTramitacionUtils.getInstance()
					.getPlateaResponseAsTask(response);
		} catch (Exception e) {
			PlateaTramitacionService.LOGGER.error(
					"Error en la llamada q99OFolderFacadeWSSoap.doTaskRegistrarDoc",
					e);

			return null;
		}
	}

}
